---
name: Bug report
about: Create a report to help us improve
labels: bug
assignees:
---

## Describe the bug

A clear and concise description of what the bug is.

## To Reproduce...

Steps to reproduce the behavior (include code examples, if applicable):

1. Create script `foo.php` and add the following:

    ``` php
    <?php
    require_once 'vendor/autoload.php';

    $foo = new Foo\Bar();

    // Code that, when run, shows the behavior...
    ```

2. Execute the script from a terminal:

    ``` bash
    $ php foo.php
    ```

3. See output similar to the following:

    ```
    Error message or wrong output...
    ```

## Expected behavior

A clear and concise description of what you expected to happen.

## Screenshots or output

If applicable, add screenshots or program output to help explain your problem.

## Environment details

 - OS: [e.g. Windows 10, Linux (Ubuntu 18.04.1), macOS Mojave (10.14.2)]
 - PHP version: [e.g. 7.1.25, 7.2.13]
 - ramsey/uuid version: [e.g. 1.0.0, 1.0.1, 1.1.0]

## Additional context

Add any other context about the problem here.
